# Code for finding the weight matrix for the indirect inference objective function
# Estimation for the data from schools of size between 4 and 50

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
from sklearn.linear_model import LinearRegression 
from sklearn.metrics import r2_score 

# Define a function: adjacency matrix to a vector of pairs
def adjpair_dir(A):
    N=A.shape[0]
    y=np.array([0])
    for k in range(1,N+1):
        a=np.concatenate((A[0:k-1,k-1],A[k:N+1,k-1]),axis=0)
        y=np.append(y,a,axis=0)
    return y[1:y.shape[0]+1] 

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to50.pkl','rb') as f:
        Data=pickle.load(f)

    # Data set-up
    Scell=Data[0]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    SDcell=Data[1]
    GE=Data[7]
    AUcell=Data[8] 
    ADcell=Data[9]
    H=len(Scell)
    k1=Xcell1[0].shape[2]
    X1=[]
    for h in range(1,H+1):
        X1.append(abs(Xcell1[h-1]))
    Xcell=X1
    R=100
    K=k1*2
    N1=np.zeros(1)
    N2=np.zeros(1)
    XX=np.zeros((1,K+1))
    A1=np.zeros(1)

    # Constructing pair-level data
    for h in range(1,H+1):
        N=SDcell[h-1].shape[0]
        A=SDcell[h-1]
        F=ADcell[h-1]
        F1obs=adjpair_dir(F)
        A1=np.concatenate((A1,F1obs),axis=0)
        m=int(N*(N-1))
        X1=np.zeros((m,K+1))
        for k in range(1,k1+1):
            X1[:,k-1]=adjpair_dir(Xcell[h-1][:,:,k-1])
            X1[:,k1+k-1]=adjpair_dir(Xcell2[h-1][:,:,k-1])
        X1[:,K]=adjpair_dir(D[h-1])
        XX=np.concatenate((XX,X1),axis=0)
        N1obs=adjpair_dir(A)
        N2obs=adjpair_dir(A*A)
        N1=np.concatenate((N1,N1obs),axis=0)
        N2=np.concatenate((N2,N2obs),axis=0)    

    xdata=XX[1:XX.shape[0]+1,:]
    ydata1=N1[1:N1.shape[0]+1]
    ydata2=N2[1:N2.shape[0]+1]
    Adata=A1[1:A1.shape[0]+1]
    AY=np.where(Adata>0)*1
    xdataF=xdata[AY]
    ydata1F=ydata1[AY]
    ydata2F=ydata2[AY]

    # Auxiliary regression (auxiliary regession equation 1) of observed data
    LM1 = LinearRegression().fit(xdataF,ydata1F)
    mu11=LM1.coef_
    mu12=np.array([LM1.intercept_])
    mu13=np.array([LM1.score(xdataF,ydata1F)])
    mu1=np.concatenate((mu12,mu11),axis=0)
    mu1=np.concatenate((mu1,mu13),axis=0)
    yhat=LM1.predict(xdataF)
    ehat=ydata1F-yhat
    N1=ehat.shape[0]
    K=22

    # Auxiliary regression (auxiliary regession equation 2) of observed data
    LM2 = LinearRegression().fit(xdataF,ydata2F)
    mu21=LM2.coef_
    mu22=LM2.intercept_
    mu23=np.array([LM2.score(xdataF,ydata2F)])
    mu=np.concatenate((mu1,mu23),axis=0)

    # Save pair-level data which will be used in the indirect inference estimation
    with open('Xdata_pair_level_Schools4to50.pkl','wb') as f:
        pickle.dump(xdata,f)

    # Set-up before estimating the weight matrix
    k1=mu.shape[0]
    random.seed(111)
    B2=3000 # Number of bootstrap samples
    bp=np.ceil(H*np.random.uniform(0,1,(H,B2)))
    muset=np.zeros((k1,B2))
    k2=11

    # Estimation of the weight matrix for indirect inference objective function
    for b in range(1,B2+1):
        hi=bp[:,b-1]
        XXb=np.zeros((1,23))
        N1b=np.zeros((1))
        N2b=np.zeros((1))
        FAb=np.zeros((1))
        for q in range(1,H+1):
            h=int(hi[q-1])
            A=SDcell[h-1]
            Fb=adjpair_dir(ADcell[h-1])
            Nb=A.shape[0]
            m=int(Nb*(Nb-1))
            X1b=np.zeros((m,K+1))
            for k in range(1,k2+1):
                X1b[:,k-1]=adjpair_dir(Xcell[h-1][:,:,k-1])
                X1b[:,k2+k-1]=adjpair_dir(Xcell2[h-1][:,:,k-1])
            X1b[:,K]=adjpair_dir(D[h-1])
            XXb=np.concatenate((XXb,X1b),axis=0)
            N1bb=adjpair_dir(A)
            N2bb=adjpair_dir(A*A)
            N1b=np.concatenate((N1b,N1bb),axis=0)
            N2b=np.concatenate((N2b,N2bb),axis=0) 
            FAb=np.concatenate((FAb,Fb),axis=0)
        Xdtb=XXb[1:XXb.shape[0]+1,:]
        N1dtb=N1b[1:N1b.shape[0]+1]
        N2dtb=N2b[1:N2b.shape[0]+1]
        Fdtb=FAb[1:FAb.shape[0]+1]
        AYb=np.where(Fdtb>0)*1
        XXbF=Xdtb[AYb]
        N1bF=N1dtb[AYb]
        N2bF=N2dtb[AYb]    
        LM1b = LinearRegression().fit(XXbF,N1bF)
        mu11=LM1b.coef_
        mu12=np.array([LM1b.intercept_])
        mu13=np.array([LM1b.score(XXbF,N1bF)])
        mu1=np.concatenate((mu12,mu11),axis=0)
        mu1b=np.concatenate((mu1,mu13),axis=0)
        LM2b = LinearRegression().fit(XXbF,N2bF)
        mu2b=np.array([LM2b.score(XXbF,N2bF)])
        mub=np.concatenate((mu1b,mu2b),axis=0)
        muset[:,b-1]=mub

    # Calculating the weight matrix
    VA=np.cov(muset)
    WA=np.linalg.inv(VA)
    Wresult=[WA,mu]
    # Save the weight matrix estimate
    with open('Wmatrix_Schools4to50.pkl','wb') as f:
        pickle.dump(Wresult,f)
